unit DataModule;

interface

uses
  SysUtils, Classes, SqlExpr, FMTBcd, DBClient, DBXCommon,
  Provider, WideStrings, DB;

type
  TDM = class(TDataModule)
    SQLDataSet1: TSQLDataSet;
    SQLDataSet1idosoby: TIntegerField;
    SQLDataSet1nazwisko: TStringField;
    SQLDataSet1imie: TStringField;
    SQLDataSet1dataur: TDateField;
    SQLDataSet1mcowosc: TStringField;
    SQLDataSet1ulicainr: TStringField;
    SQLDataSet1kodp: TStringField;
    SQLDataSet1miasto: TStringField;
    SQLDataSet1pesel: TStringField;
    DataSetProvider1: TDataSetProvider;
    DataSource1: TDataSource;
    ClientDataSet1: TClientDataSet;
    ClientDataSet1idosoby: TIntegerField;
    ClientDataSet1nazwisko: TStringField;
    ClientDataSet1imie: TStringField;
    ClientDataSet1dataur: TDateField;
    ClientDataSet1mcowosc: TStringField;
    ClientDataSet1ulicainr: TStringField;
    ClientDataSet1kodp: TStringField;
    ClientDataSet1miasto: TStringField;
    ClientDataSet1pesel: TStringField;
    SQLDataSetInsert: TSQLDataSet;
    SQLDataSetEdit: TSQLDataSet;
    SQLDataSetDelete: TSQLDataSet;
    SQLConnection1: TSQLConnection;
    SQLMonitor: TSQLMonitor;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure SQLMonitorLogTrace(Sender: TObject; TraceInfo: TDBXTraceInfo);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DM: TDM;

implementation

{$R *.dfm}

procedure TDM.DataModuleCreate(Sender: TObject);
begin
   SQLDataSet1.Active    := True;
   ClientDataSet1.Active := True;
   SQLMonitor.Active     := True;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   SQLDataSet1.Active    := False;
   ClientDataSet1.Active := False;
   SQLMonitor.Active     := False;   
   SQLConnection1.Close();
end;

procedure TDM.SQLMonitorLogTrace(Sender: TObject; TraceInfo: TDBXTraceInfo);
begin
   SQLMonitor.SaveToFile('sql.log');
end;

end.
